/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.util;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the LockableImpl class for basic functionality
 *
 *
 * @author Michael Bryzek
 * @see LockableImpl
 * @version 1.0
 **/

public class LockableImplTest extends TestCase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/util/LockableImplTest.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private LockableImpl m_lockableImpl;

    /**
     * Constructs a LockableImplTest with the specified name.
     *
     * @param name Test case name.
     **/
    public LockableImplTest(String name) {
        super(name);
    }


    /**
     * Sets up the text fixture.
     *
     * Called before every test case method.
     **/
    protected void setUp() {
        m_lockableImpl = new LockableImpl();
    }


    /**
     * Tears down the text fixture.
     *
     * Called after every test case method.
     **/
    protected void tearDown() {
        m_lockableImpl = null;
    }


    /**
     * Test lock and isLock behavior
     **/
    public void testValid() {
        assertTrue("LockableImpl object should not be locked by default",
                   ! m_lockableImpl.isLocked());
        m_lockableImpl.lock();

        assertTrue("LockableImpl object must be locked after explicit locking",
                   m_lockableImpl.isLocked());
    }

    /**
     * Assembles and returns a test suite for
     * all the test methods of this test case.
     *
     * @return A non-null test suite.
     **/
    public static Test suite() {
        return new TestSuite(LockableImplTest.class);
    }

    public static void main(String args[]) {
        junit.textui.TestRunner.run(suite());
    }
}
