/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.form;

import com.arsdigita.bebop.*;
import com.arsdigita.bebop.event.*;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.util.HttpServletDummyRequest;
import com.arsdigita.util.HttpServletDummyResponse;

import java.util.Calendar;

/**
 * Regression tests for the text field widget
 *
 * @version $Revision: #10 $ $Date: 2004/04/07 $
 */

public class DateTest extends Fixture {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/form/DateTest.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public DateTest (String id) {
        super(id);
    }

    /**
     *  Test a Date
     */
    public void testDate() {
        //testWidget(new Date("birth"), "one");
    }

    /**
     * Test to make sure date field works after we call setValue
     * on the pageState.  Corresponds to SDM #196277.
     */
    public void testDayField() throws Exception {
        final Date dt = new Date("dt");
        m_form.add(dt);
        // NOTE:
        // this is convoluted and uses a FormInitListener instead of a
        // PrintListener because I couldn't get dt.setValue() to have
        // any effect in a print listener.  Oddly, the print-listener
        // version that calls dt.setValue(ps, ...); works fine in a test
        // page when there's a real request around.
        m_form.addInitListener(new FormInitListener() {
                public void init(FormSectionEvent evt) {
                    Calendar cal = Calendar.getInstance();
                    cal.set(2004, Calendar.FEBRUARY, 29);
                    evt.getFormData().put(dt.getName(), cal.getTime());
                }
            });
        final ComponentTestHarness harness = new ComponentTestHarness(m_page);

        final String docXML = harness.generateXML().toString();
        assertTrue(docXML.indexOf("value=\"29\"") >= 0);
    }
}
