/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import java.util.Map;
import java.util.HashMap;

/**
 * Regression tests for the List component.
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */

public class ListTest extends XMLComponentRegressionBase {

    public static final String versionId = "$Id: //core-platform/dev/test/src/com/arsdigita/bebop/ListTest.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public ListTest (String id) {
        super(id);
    }

    /**
     *  Test empty List
     */
    public void testEmptyList() {
        testComponent(new List(),"empty");
    }

    /**
     *  Test created a List from a Map
     */
    public void testMapList() {
        Map map = new HashMap();
        map.put("key1","value1");
        map.put("key2","value2");
        testComponent(new List(map),"map");
    }



}
