/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.workflow.simple;

import java.util.Iterator;

import com.arsdigita.kernel.User;
import com.arsdigita.kernel.Group;


/**
 * Interface for assignment capability to a class.
 *
 * @author Karl GoldStein 
 * @author Khy Huang      
 * @author Stefan Deusch  
 *
 **/
public interface Assignable {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/Assignable.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Assigns a user to this task. (persistent operation)
     *
     * @param user an active user of the system
     *
     **/
    public void assignUser(User user);

    /**
     * Assigns a group of users to this task. (persistent operation)
     *
     * @param group a group of users
     *
     **/
    public void assignGroup(Group group);

    /**
     * Removes a user from the task assignment list.
     *
     * @param user the user to remove
     *
     **/
    public void removeUser(User user);

    /**
     * Removes a group from the task assignment list.
     *
     * @param group the group to remove
     *
     **/
    public void removeGroup(Group group);


    /**
     * Tests whether any user is assigned to this task.
     *
     * @return <code>true</code> if anyone is assigned
     * to this task; <code>false</code> otherwise.
     *
     **/
    public boolean isAssigned();

    /**
     * Tests whether a user is assigned to this task.
     *
     * @param user a system user
     * @return <code>true</code> if the user is assigned
     * to this task; <code>false</code> otherwise.
     *
     **/
    public boolean isAssigned(User user);

    /**
     * Tests whether a group is assigned to this task.
     *
     * @param group aA user group
     * @return <code>true</code> if the group is assigned
     * to this task; <code>false</code> otherwise.
     *
     **/
    public boolean isAssigned(Group group);

    /**
     * Returns a GroupCollection over the set of groups assigned to this task.
     *
     * @return the groups assigned to this task.
     *
     **/
    public Iterator getAssignedGroups();

    /**
     * Returns a UserCollection over the set of users assigned to this task.
     *
     * @return the users assigned to this task.
     *
     **/
    public Iterator getAssignedUsers();


}
