/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.webdevsupport.log4j;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;

import org.apache.log4j.Logger;
import org.apache.log4j.Level;

/**
 * Log4j logger level adjuster
 *
 * Created: Mon Jul 29 14:01:52 2002
 *
 * @author <a href="mailto:dan@camden.london.redhat.com">Daniel Berrange</a>
 * @version $Date: 2004/04/07 $
 */

public class CategoryPanel extends SimpleContainer {

    private CategoryTable m_categories;
    private CategoryForm m_form;

    public CategoryPanel() {

        m_categories = new CategoryTable();
        m_form = new CategoryForm();

        m_form.addProcessListener(new FormProcessListener() {
                public void process(FormSectionEvent e)
                    throws FormProcessException {

                    PageState state = e.getPageState();

                    String category = m_form.getLogger(state);
                    String level = m_form.getLevel(state);

                    m_form.setLogger(state, "");
                    m_form.setLevel(state, "DEBUG");

                    Logger.getLogger(category).setLevel(Level.toLevel(level));
                    m_categories.getRowSelectionModel().clearSelection(state);
                }
            });

        m_categories.addTableActionListener(new TableActionListener() {
                public void cellSelected(TableActionEvent e) {
                    PageState state = e.getPageState();
                    Logger cat = Logger.getLogger((String)e.getRowKey());
                    Level level = cat.getLevel();

                    m_form.setLogger(state, cat.getName());
                    m_form.setLevel(state,
                                    level != null ? level.toString() : "DEBUG");
                }
                public void headSelected(TableActionEvent e) {
                }
            });

        add(m_form);
        add(m_categories);
    }

}// CategoryPanel
