/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.util.StringUtils;

import java.util.HashMap;

/**
 *
 * @author Joseph A. Bank (jbank@alum.mit.edu)
 * @version 1.0
 **/
public class QueryInfo {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/webdevsupport/QueryInfo.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private int m_id;
    private int m_connection_id;
    private String m_type;
    private String m_query;
    private HashMap m_bindvars;
    private long m_time;
    private java.sql.SQLException m_sqle;
    private Throwable m_stack_trace;

    public QueryInfo(int id,
                     int connection_id,
                     String type,
                     String query,
                     HashMap bindvars,
                     long time,
                     java.sql.SQLException sqle) {
        m_id = id;
        m_connection_id = connection_id;
        m_type = type;
        m_query = query;
        m_bindvars = bindvars;
        m_time = time;
        m_sqle = sqle;
        m_stack_trace = new Throwable();
    }

    public int getID() {
        return m_id;
    }
    public int getConnectionID() {
        return m_connection_id;
    }
    public String getType() {
        return m_type;
    }
    public String getQuery() {
        return m_query;
    }
    public HashMap getBindvars() {
        return m_bindvars;
    }
    public long getTime() {
        return m_time;
    }
    public java.sql.SQLException getSQLE() {
        return m_sqle;
    };

    public String getStackTrace() {
        String result = StringUtils.getStackTrace(m_stack_trace);
        //look for the last "DeveloperSupport.logQuery" command
        int i;
        int j;
        if (((i = result.indexOf("DeveloperSupport.logQuery")) != -1) &&
            ((j = result.indexOf("\n", i)) != -1)) {
            result = result.substring(j);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof QueryInfo) {
            QueryInfo qi = (QueryInfo)o;
            boolean bindvars_equals;
            if (qi.getBindvars() == null) {
                bindvars_equals = (getBindvars() == null);
            } else {
                bindvars_equals = qi.getBindvars().equals(getBindvars());
            }
            return bindvars_equals &&
                qi.getQuery().equals(getQuery());
        }
        return false;
    }
    public int hashCode() {
        return getQuery().hashCode();
    }
}
