/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.webdevsupport;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.BaseInitializer;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;

import com.arsdigita.developersupport.DeveloperSupport;
import org.apache.log4j.Logger;

/**
 * Initializer
 *
 * @version $Revision: #16 $ $Date: 2004/04/07 $
 */

public class Initializer extends BaseInitializer {

    private Configuration m_conf = new Configuration();

    public final static String ACTIVE = "active";

    private static final Logger s_log =
        Logger.getLogger(Initializer.class);

    public Initializer() throws InitializationException {
        m_conf.initParameter(ACTIVE,
                             "Flag to turn on/off developer support",
                             Boolean.class);
    }

    /**
     * Returns the configuration object used by this initializer.
     **/
    public Configuration getConfiguration() {
        return m_conf;
    }


    /**
     * Called on startup.
     **/
    protected void doStartup() {
        Boolean active = (Boolean)m_conf.getParameter(ACTIVE);
        if (Boolean.TRUE.equals(active)) {
            s_log.debug("Registering webdev listener");
            DeveloperSupport.addListener(WebDevSupport.getInstance());
        }
    }

    /**
     * Called on shutdown. It's probably not a good idea to depend on this
     * being called.
     **/
    protected void doShutdown() { }


}
