/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import com.arsdigita.developersupport.Debug;
import com.arsdigita.initializer.Script;
import com.arsdigita.util.ResourceManager;
import java.io.InputStream;
import javax.servlet.ServletException;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Revision: #4 $ $Date: 2004/04/07 $
 */
public final class LegacyInitializerServlet extends BaseServlet {
    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/web/LegacyInitializerServlet.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private Script m_initializer = null;

    /**
     * Starts up the web environment for the ACS by loading the specified
     * initializer script.
     */
    protected final void doInit() throws ServletException {
        Debug.setLevel("com.arsdigita.initializer.Script", "info");

        final String script = getServletConfig().getInitParameter("init");

        final ResourceManager rm = ResourceManager.getInstance();
        rm.setServletContext(getServletContext());

        final InputStream is = rm.getResourceAsStream(script);

        if (is == null) {
            throw new ServletException("Couldn't find " + script);
        }

        m_initializer = new Script(is);
        m_initializer.startup();
    }

    protected final void doDestroy() {
        m_initializer.shutdown();
        m_initializer = null;
    }
}
