/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import java.util.Enumeration;
import java.security.Principal;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.Cookie;

public class HttpServletRequestWrapper extends ServletRequestWrapper
        implements HttpServletRequest {
    private final HttpServletRequest m_req;

    public HttpServletRequestWrapper(HttpServletRequest req) {
        super(req);

        m_req = req;
    }

    public String getAuthType() {
        return m_req.getAuthType();
    }

    public String getContextPath() {
        return m_req.getContextPath();
    }

    public Cookie[] getCookies() {
        return m_req.getCookies();
    }

    public long getDateHeader(String name) {
        return m_req.getDateHeader(name);
    }

    public String getHeader(String name) {
        return m_req.getHeader(name);
    }

    public Enumeration getHeaderNames() {
        return m_req.getHeaderNames();
    }

    public Enumeration getHeaders(String name) {
        return m_req.getHeaders(name);
    }

    public int getIntHeader(String name) {
        return m_req.getIntHeader(name);
    }

    public String getMethod() {
        return m_req.getMethod();
    }

    public String getPathInfo() {
        return m_req.getPathInfo();
    }

    public String getPathTranslated() {
        return m_req.getPathTranslated();
    }

    public String getQueryString() {
        return m_req.getQueryString();
    }

    public String getRemoteUser() {
        return m_req.getRemoteUser();
    }

    public String getRequestedSessionId() {
        return m_req.getRequestedSessionId();
    }

    public String getRequestURI() {
        return m_req.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        throw new UnsupportedOperationException
            ("This is a Servlet 2.3 feature that we do not currently support");
    }

    public String getServletPath() {
        return m_req.getServletPath();
    }

    public HttpSession getSession() {
        return m_req.getSession();
    }

    public HttpSession getSession(boolean create) {
        return m_req.getSession(create);
    }

    public Principal getUserPrincipal() {
        return m_req.getUserPrincipal();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return m_req.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return m_req.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromURL() {
        return m_req.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdValid() {
        return m_req.isRequestedSessionIdValid();
    }

    public boolean isUserInRole(String role) {
        return m_req.isUserInRole(role);
    }
}
