/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletContext;
import javax.servlet.RequestDispatcher;

import org.apache.log4j.Logger;


public class DefaultApplicationFileResolver implements ApplicationFileResolver {

    private static final String[] WELCOME_FILES = new String[] {
        "index.jsp", "index.html"
    };

    private static Logger s_log = 
        Logger.getLogger(DefaultApplicationFileResolver.class);

    public RequestDispatcher resolve(String templatePath,
                                     HttpServletRequest sreq,
                                     HttpServletResponse sresp,
                                     Application app) {
        // XXX proper list of dependent & customization webapps to search
        String[] webapps = new String[] {
            app.getContextPath(), "ROOT"
        };
        String pathInfo = sreq.getPathInfo();

        if (s_log.isDebugEnabled()) {
            s_log.debug("Resolving resource for " + pathInfo);
        }

        String node = app.getPath();
        do {
            String path = templatePath + node + pathInfo;

            
            if (path.endsWith("/")) {
                for (int i = 0 ; i < WELCOME_FILES.length ; i++) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug("Trying welcome resource " + 
                                    path + WELCOME_FILES[i]);
                    }

                    RequestDispatcher rd = Web.findResourceDispatcher(
                        webapps,
                        path + WELCOME_FILES[i]);
                    if (rd != null) {
                        if (s_log.isDebugEnabled()) {
                            s_log.debug("Got dispatcher " + rd);
                        }
                        return rd;
                    }
                }
            } else {
                if (s_log.isDebugEnabled()) {
                    s_log.debug("Trying resource " + path);
                }
                
                RequestDispatcher rd = Web.findResourceDispatcher(
                    webapps,
                    path);
                if (rd != null) {
                    if (s_log.isDebugEnabled()) {
                        s_log.debug("Got dispatcher " + rd);
                    }
                    return rd;
                }
            }
            if ("".equals(node)) {
                node = null;
            } else {
                int index = node.lastIndexOf("/", node.length() - 2);
                node = node.substring(0, index);
            }
        } while (node != null);

        if (s_log.isDebugEnabled()) {
            s_log.debug("No dispatcher found");
        }
        
        return null;
    }
    
}
