/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.redhat.persistence.EventProcessor;
import com.redhat.persistence.EventProcessorManager;

// new versioning

/**
 * This class interfaces the versioning package with persistence.
 *
 * <p>The versioning initializer registers this event processor manager with the
 * {@link com.arsdigita.persistence.SessionManager}. When the session manager
 * spawns a new session, it queries this processor manager for an instance of an
 * event processor to be registered with the newly spawned session.  The session
 * then becomes responsible for dispatching persistence events to the {@link
 * VersioningEventProcessor versioning event processor}. </p>
 *
 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @since 2003-02-28
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/
final class VersioningProcessorManager implements EventProcessorManager {
    private static final ThreadLocal s_processor = new ThreadLocal() {
            public Object initialValue() {
                return new VersioningEventProcessor();
            }
        };

    VersioningProcessorManager() {}

    public EventProcessor getEventProcessor() {
        return getVersioningEventProcessor();
    }

    static VersioningEventProcessor getVersioningEventProcessor() {
        return (VersioningEventProcessor) s_processor.get();
    }
}
