/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterRecord;
import org.apache.log4j.Logger;

/**
 * @author Justin Ross
 */
public final class VersioningConfig extends ParameterRecord {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/versioning/VersioningConfig.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger(VersioningConfig.class);

    private final Parameter m_debug;

    public VersioningConfig() {
        super("versioning");

        m_debug = new BooleanParameter
            ("waf.versioning.debug_ui_enabled", Parameter.REQUIRED, Boolean.FALSE);

        register(m_debug);
	loadInfo();
    }

    boolean isDebugUIEnabled() {
        return ((Boolean) get(m_debug)).booleanValue();
    }
}
