/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

// new versioning

final class EventType {

    private final static Map s_types = new HashMap(5);
    private DataObject m_dobj;
    

    // the following need to be kept in sync with
    // sql/default/versioning/insert-vcx_events.sql
    public final static int CREATE_SWITCH = 1;
    public final static EventType CREATE = newEventType(CREATE_SWITCH, "create");
    public final static int DELETE_SWITCH = 2;
    public final static EventType DELETE = newEventType(DELETE_SWITCH, "delete");
    public final static int ADD_SWITCH    = 3;
    public final static EventType ADD    = newEventType(ADD_SWITCH, "add");
    public final static int REMOVE_SWITCH = 4;
    public final static EventType REMOVE = newEventType(REMOVE_SWITCH, "remove");
    public final static int SET_SWITCH = 5;
    public final static EventType SET    = newEventType(SET_SWITCH, "set");

    private final static String DATA_TYPE = Constants.PDL_MODEL + ".EventType";

    private final BigInteger m_id;
    private final String m_name;

    private EventType(BigInteger id, String name) {
        m_id = id;
        m_name = name;
    }

    private static EventType newEventType(int id, String name) {
        BigInteger iid = new BigInteger(String.valueOf(id));
        EventType result = new EventType(iid, name);
        s_types.put(iid, result);
        return result;
    }

    static void initialize() {
        if (Initializer.hasRun()) {
            throw new IllegalStateException("can't be called more than once");
        }
        for (Iterator ii=s_types.values().iterator(); ii.hasNext(); ) {
            EventType type = (EventType) ii.next();
            type.getDataObject();
        }
    }

    synchronized DataObject getDataObject() {
        if ( m_dobj == null ) {
            m_dobj = SessionManager.getSession().retrieve(new OID(DATA_TYPE, m_id));
            m_dobj.disconnect();
        }

        return m_dobj;
    }

    static EventType getEventType(DataObject ev) {
        BigInteger id = (BigInteger) ev.get("id");
        Assert.truth(s_types.containsKey(id), "s_types.contains(id)");
        return (EventType) s_types.get(id);
    }

    public boolean equals(Object obj) {
        return obj == this;
    }

    int intValue() {
        return m_id.intValue();
    }

    public int hashCode() {
        return intValue();
    }

    public String toString() {
        return m_name;
    }
}
