/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.versioning;

// new versioning

/**
 * <p>This class should only be used in debugging as a means of non-local control
 * transfer.  Checked in code should not make use of this class.</p>
 *
 * <p>Suppose you are debugging an exceptional condition that can only be
 * detected in method <code>foo()</code>.  However, the available context inside
 * of <code>foo()</code> is insufficient to determine the real cause of the
 * exception condition.  You have to backtrack and examine the context of the
 * caller's of <code>foo()</code>.  You can use this class as a means of
 * non-local control transfer. Throw a <code>DebugException</code> from within
 * <code>foo()</code> and catch somewhere down the stack, where more information
 * can be gathered regarding the real cause of the error. </p>
 *
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2003-09-15
 * @version $Revision: #3 $ $DateTime: 2004/04/07 16:07:11 $
 **/
class DebugException extends VersioningException {

    public DebugException() {
        super((String) null);
    }

    public DebugException(String msg) {
        super(msg);
    }

    public DebugException(String msg, Throwable rootCause) {
        super(msg, rootCause);
    }

    public DebugException(Throwable rootCause) {
        super(rootCause);
    }
}
