/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

/**
 * A page that displays all <code>ACSObjects</code> that the user has
 * the "admin" privilege on. It also includes a search box for finding
 * <code>ACSObjects</code> by ID.
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/ui/permissions/IndexPanel.java#10 $
 */
class IndexPanel extends SimpleContainer implements PermissionsConstants  {
    private static final String OBJECT_QUERY =
        "com.arsdigita.ui.permissions.PermissionObjects";
    private static final String ACSOBJECT_ID =
        "objectID";

    private SegmentedPanel m_segmentedPanel;
    private List m_adminObjs;
    private Label m_listHeader;
    private DimensionalNavbar m_navbar;

    /**
     * Constructor
     */

    public IndexPanel() {
        setClassAttr("PERMISSIONS");
        m_navbar = new DimensionalNavbar();
        m_navbar.add(new Link(PERSONAL_SITE.localize()+"", 
                              "/" + Initializer.getURL(
                                  Initializer.WORKSPACE_PAGE_KEY)));
        m_navbar.add(new Link(MAIN_SITE.localize()+"", "/"));
        m_navbar.add(new Label(PERMISSIONS_INDEX_NAVBAR.localize()+""));
        m_navbar.setClassAttr("permNavBar");
        add(m_navbar);

        m_listHeader = new Label(PAGE_OBJECT_INDEX);

        m_adminObjs = new List(new AdminObjectsPermListBuilder());
        m_adminObjs.setCellRenderer(new ListObjectLinkRenderer());
        m_adminObjs.setClassAttr("bulletList");

        BoxPanel boxpanel = new BoxPanel();
        boxpanel.add(m_listHeader);
        boxpanel.add(m_adminObjs);

        m_segmentedPanel = new SegmentedPanel();
        m_segmentedPanel.addSegment(new Label(PAGE_OBJECT_PANEL_TITLE.localize()+""), boxpanel);
        add(m_segmentedPanel);
    }

    /**
     * Internal class for a ListBuilder that with all
     * ACSObjects for which the user has ADMIN privilege
     */
    private class AdminObjectsPermListBuilder extends LockableImpl
            implements ListModelBuilder {

        public ListModel makeModel(List l, PageState s) {
            Party party = Kernel.getContext().getParty();

            DataQuery query = SessionManager.getSession().retrieveQuery
                (OBJECT_QUERY);
            PermissionService.filterQuery(query,
                                          ACSOBJECT_ID ,
                                          PrivilegeDescriptor.ADMIN,
                                          party.getOID());
            return new AdminObjectsPermListModel(query);
        }
    }


    private class AdminObjectsPermListModel implements ListModel {
        private DataQuery m_query;
        private BigDecimal m_id;
        private ACSObject m_object;

        AdminObjectsPermListModel(DataQuery query) {
            m_query = query;
        }

        public boolean next() {
            if(m_query.next()) {
                m_id = (BigDecimal)m_query.get(ACSOBJECT_ID );
                m_object = UserObjectStruct.loadObject(m_id);
                return true;
            }
            m_query.close();
            return false;
        }

        public String getKey() {
            return  m_object.getID().toString();
        }

        public Object getElement() {
            return m_object.getDisplayName();
        }
    }

    private final class ListObjectLinkRenderer implements ListCellRenderer {

        public Component getComponent(List list, PageState state, Object value,
                                      String key, int index, boolean isSelected) {

            Link link = new Link((String)value,
                                 "/permissions/one?"+OBJECT_ID+"="+key);
            return link;
        }
    }

}
