/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui.login;

import com.arsdigita.kernel.KernelHelper; 
import com.arsdigita.kernel.User; 
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.StringParameter;
import org.apache.log4j.Logger;

/**
 * Initializes the value of the given parameter to the current user's
 * screen name.  Strangely similar to <code>EmailInitListener</code>.
 *
 * @author <a href="mailto:cwolfe@redhat.com">Crag Wolfe</a>
 **/
public class ScreenNameInitListener implements FormInitListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/ui/login/ScreenNameInitListener.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = 
        Logger.getLogger(ScreenNameInitListener.class.getName());
    private StringParameter m_param;
    public ScreenNameInitListener(StringParameter param) {
	m_param = param;
    }
    
    public void init(FormSectionEvent event) {
	PageState state = event.getPageState();
	FormData data = event.getFormData();
	s_log.debug("START");
	UserContext ctx = KernelHelper
	    .getKernelRequestContext(state.getRequest())
	    .getUserContext();
	if (!ctx.isLoggedIn()) {
	    s_log.debug("FAILURE not logged in");
	    return;
	}
	User user = null;
        user = ctx.getUser();
	if (user.getScreenName() == null) {
	    s_log.debug("FAILURE null screen name");
	    return;
	}
	data.put(m_param.getName(), user.getScreenName());
	s_log.debug("SUCCESS");
    }
}
