/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui;

import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.PageState;
import com.arsdigita.xml.Element;
import com.arsdigita.kernel.KernelHelper;

public class SiteBanner extends SimpleComponent {

    public void generateXML(PageState state,
                            Element parent) {
        Element content = parent.newChildElement("ui:siteBanner",
                                                 UIConstants.UI_XML_NS);
        exportAttributes(content);

        content.addAttribute("hostname", 
                             KernelHelper.getHostName());
        content.addAttribute("sitename", 
                             KernelHelper.getSiteName());
        content.addAttribute("admin", 
                             KernelHelper.getSystemAdministratorEmailAddress());
    }
}
