/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.xml.Element;
import com.arsdigita.ui.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;

public class DebugPanel extends SimpleComponent {

    private static final GlobalizedMessage s_transformOn;
    private static final GlobalizedMessage s_transformOff;
    private static final GlobalizedMessage s_xml;
    private static final GlobalizedMessage s_xsl;

    private static final String TYPE_GENERIC = "generic";
    private static final String TYPE_ENABLE = "add";
    private static final String TYPE_DISABLE = "delete";

    static {
        s_transformOn = GlobalizationUtil.globalize("ui.debug.transform.on");
        s_transformOff = GlobalizationUtil.globalize("ui.debug.transform.off");
        s_xml = GlobalizationUtil.globalize("ui.debug.xml");
        s_xsl = GlobalizationUtil.globalize("ui.debug.xsl");
    }

    public void generateXML(PageState state,
                            Element parent) {
        if (!Kernel.getConfig().isDebugEnabled()) {
            return;
        }

        Element content = parent.newChildElement("ui:debugPanel",
                                                 UIConstants.UI_XML_NS);
        exportAttributes(content);
        
        URL here = Web.getContext().getRequestURL();
        
        URL xmlURL = selfURL(state, here, "output", "xml");
        URL xslURL = selfURL(state, here, "output", "xsl");
        URL transformOnURL = selfURL(state, here, "debug", "transform");
        URL transformOffURL = selfURL(state, here, "debug", null);
        
        generateLinkXML(state, content, s_xml, xmlURL, TYPE_GENERIC);
        generateLinkXML(state, content, s_xsl, xslURL, TYPE_GENERIC);
        if (here.getParameter("debug") == null) {
            generateLinkXML(state, content, s_transformOn, 
                            transformOnURL, TYPE_ENABLE);
        } else {
            generateLinkXML(state, content, s_transformOff, 
                            transformOffURL, TYPE_DISABLE);
        }
    }
    
    private void generateLinkXML(PageState state,
                                 Element parent,
                                 GlobalizedMessage msg,
                                 URL url,
                                 String type) {
        Element link = parent.newChildElement("ui:debugLink",
                                              UIConstants.UI_XML_NS);
        link.addAttribute("title", (String)msg.localize(state.getRequest()));
        link.addAttribute("url", url.toString());
        link.addAttribute("type", type);
    }
    
    private URL selfURL(PageState state,
                        URL here,
                        String name,
                        String value) {
        ParameterMap params = new ParameterMap(here.getParameterMap());
        params.clearParameter(name);
        if (value != null) {
            params.setParameter(name, value);
        }
        
        // XXX, can't use this because it triggers the
        // parameter listeners which clobber the 'debug'
        // parameter we're already setting.
        /*
        return URL.there(state.getRequest(),
                         here.getPathInfo(),
                         params);
        */
        
        return new URL(here.getScheme(),
                       here.getServerName(),
                       here.getServerPort(),
                       here.getContextPath(),
                       here.getServletPath(),
                       here.getPathInfo(),
                       params);
    }
}
