/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.util.MessageType;

/**
 * Provides a widget for selecting between HTML, plain text, and
 * preformatted text.
 *
 * $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/TextTypeWidget.java#8 $
 */

public class TextTypeWidget extends SingleSelect {

    private Option m_html  = new Option(MessageType.TEXT_HTML,
                                        "HTML");
    private Option m_plain = new Option(MessageType.TEXT_PLAIN,
                                        "Plain");
    private Option m_pre   = new Option(MessageType.TEXT_PREFORMATTED,
                                        "Preformatted Text");
    private Option m_smart = new Option(MessageType.TEXT_SMART,
                                        "Smart Text");

    /**
     * Constructor.
     */

    public TextTypeWidget(ParameterModel textTypeParameter)
    {
        super(textTypeParameter);

        // Add options
        addOption(m_html);
        addOption(m_plain);
        addOption(m_pre);
        addOption(m_smart);
    }

    /**
     * Constructor with one additional parameter to set the correct
     * default value, which should be one of the constants defined by
     * the {@link MessageType} interface. Example:
     *
     * <pre>
     * TextTextWidget ttw = new TextTypeWidget(model, MessageType.TEXT_PLAIN);
     * </pre>
     */

    public TextTypeWidget(ParameterModel textTypeParameter,
                          String defaultType)
    {
        this(textTypeParameter);

        // Set default value
        setOptionSelected(defaultType);
    }
}
