/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.xml.Element;
import java.util.Iterator;
import java.util.Collections;
import javax.servlet.ServletException;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/NullComponent.java#5 $
 */
public final class NullComponent implements Component {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/NullComponent.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    public void generateXML(PageState state, Element parent) {
        // Empty
    }

    public void respond(PageState state) throws ServletException {
        // Empty
    }

    public Iterator children() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void register(Page page) {
        // Empty
    }

    public void register(Form form, FormModel model) {
        // Empty
    }

    public String getClassAttr() {
        return null;
    }

    public void setClassAttr(String clacc) {
        // Empty
    }

    public String getStyleAttr() {
        return null;
    }

    public void setStyleAttr(String style) {
        // Empty
    }

    public String getIdAttr() {
        return null;
    }

    public void setIdAttr(String id) {
        // Empty
    }

    public Component setKey(String key) {
        return null;
    }

    public String getKey() {
        return null;
    }

    public boolean isVisible(PageState state) {
        return false;
    }

    public void setVisible(PageState state, boolean visible) {
        // Empty
    }

    public void lock() {
        // Empty
    }
    
    public boolean isLocked() {
        return true;
    }
}
