/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Link;
import com.arsdigita.xml.Element;

/**
 * 
 *
 * @author Justin Ross
 * @version $Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ItemDetailAction.java#9 $
 */
public class ItemDetailAction {
    String m_name;
    String m_url;

    public ItemDetailAction(String name, String url) {
        m_name = name;
        m_url = url;
    }

    public void generateXML(PageState pageState, Element parent) {
        Element action = new Element("bebop:action", Component.BEBOP_XML_NS);
        parent.addContent(action);

        Link link = new Link(m_name, m_url);
        link.generateXML(pageState, action);
    }
}
