/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.toolbox.Security;

import java.util.ArrayList;
import java.util.Iterator;

import org.apache.log4j.Logger;

/**
 * <p>Wrapper class that registers access checks (actions) to a
 * Bebop component.</p>
 *
 * @author Michael Pih 
 * @version $Revision: #10 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class ComponentAccess {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/ComponentAccess.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Component m_component;
    private ArrayList m_list;

    private static final Logger s_log =
        Logger.getLogger(ComponentAccess.class);


    /**
     * @param c The component
     */
    public ComponentAccess(Component c) {
        m_list = new ArrayList();
        m_component = c;
    }

    /**
     * @param c The component
     * @param check An access check
     */
    public ComponentAccess(Component c, String check) {
        this(c);
        addAccessCheck(check);
    }

    /**
     * Add an access check to this component.
     *
     * @param check The access check
     */
    public void addAccessCheck(String check) {
        m_list.add(check);
    }

    /**
     * Get the access checks.
     *
     * @return The list of access checks
     */
    public ArrayList getAccessCheckList() {
        return m_list;
    }

    /**
     * Get the component.
     *
     * @return The component
     */
    public Component getComponent() {
        return m_component;
    }

    /**
     * Do all the access checks registered to the component pass?
     *
     * @param state The page state
     * @param security The Security implementation that will perform
     *    the access checks
     * @return true if all the access checks pass, false otherwise
     */
    public boolean canAccess(PageState state, Security security) {
        boolean canAccess = true;

        Party party = Kernel.getContext().getParty();

        for ( Iterator i = getAccessCheckList().iterator(); i.hasNext(); ) {
            String check = (String) i.next();
            if ( !security.canAccess(party, check) ) {
                canAccess = false;
                break;
            }
        }

        return canAccess;
    }

}
