/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.util.LockableImpl;
import com.arsdigita.bebop.PageState;

import com.arsdigita.persistence.DataQuery;

/**
 * An abstract class that implements DataQueryBuilder, allowing on the fly
 * implementations of DataQueryBuilder.
 */
public abstract class AbstractDataQueryBuilder extends LockableImpl
    implements DataQueryBuilder {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/AbstractDataQueryBuilder.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Perform all neccessary database operations and return
     * a {@link DataQuery} for the {@link DataTable} to use
     *
     * @param t the parent DataTable
     * @param s the page state
     */
    public abstract DataQuery makeDataQuery(DataTable t, PageState s);

    /**
     * @return the name of the column in the query that serves
     *   as the primary key for the items
     */
    public abstract String getKeyColumn();
}
