/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating.jsp;


import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.TagSupport;

/**
 * Includes a JSP component in the current JSP.
 *
 * <p>Usage:</p>
 *
 * <pre><code>&lt;acs:include path="path/to/component.jsp" />
 **/
public class IncludeTag extends TagSupport {

    private String path = null;

    public IncludeTag() {

        super();
    }

    public void setPath(String path) {

        this.path = path;
    }

    public int doStartTag() throws JspTagException {

        try {

            pageContext.include(path);

        } catch (Exception e) {
            throw new JspTagException(e.getMessage());
        }

        return EVAL_PAGE;
    }

    public void release() {

        this.path = null;
    }
}
