/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating.html;

import com.arsdigita.templating.html.AttributeMap;
import com.arsdigita.util.Assert;

/**
 * An implementation of {@link AttributeMap.Pair}.
 *
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2002-08-29
 * @version $Id: //core-platform/dev/src/com/arsdigita/templating/html/PairImpl.java#4 $
 **/
final class PairImpl implements AttributeMap.Pair {
    String m_qName;
    String m_value;

    public PairImpl(String qName, String value) {
        setName(qName);
        setValue(value);
    }

    public String getName() {
        return m_qName;
    }

    public String getValue() {
        return m_value;
    }

    public void setName(String qName) {
        Assert.assertNotNull(qName, "qName");
        m_qName = qName;
    }

    public void setValue(String value) {
        Assert.assertNotNull(value, "value");
        m_value = value;
    }
}
