/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating.html;

import com.arsdigita.templating.html.HTMLParserConfigurationException;

/**
 * Different projects may need different {@link
 * com.arsdigita.templating.html.HTMLParser HTML parsers}. Some people would be
 * happy with the {@link com.arsdigita.templating.html.XHTMLParser} which only
 * accepts well-formed XHTML fragments, while others may want to write a parser
 * that accepts malformed HTML. This factory can be configured to return a
 * particular desired implementation of the {@link
 * com.arsdigita.templating.html.HTMLParser} interface.
 *
 * @author Vadim Nasardinov (vadimn@redhat.com)
 * @since 2002-09-09
 * @version $Date: 2004/04/07 $
 **/
public class HTMLParserFactory {

    /**
     * @post return != null
     **/
    public static HTMLParser newInstance()
        throws HTMLParserConfigurationException, HTMLParserException {

        // FIXME: this should be driven by a config file.
        return new XHTMLParser();
    }
}
