/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.templating.html;

import java.util.Iterator;

/**
 * Similar to the <a
 * href="http://java.sun.com/xml/jaxp/dist/1.1/docs/api/org/xml/sax/Attributes.html"><i>Attributes</i></a>
 * interface in SAX. Not really a {@link java.util.Map}, insofar as it only
 * supports a subset of the <code>Map</code> methods.
 *
 * <p>One of the reasons this is an interface rather than a class is because we
 * don't want <code>AttributeMap</code> to have any setter methods. </p>
 *
 * @author  Vadim Nasardinov (vadimn@redhat.com)
 * @since   2002-08-29
 * @version $Id: //core-platform/dev/src/com/arsdigita/templating/html/AttributeMap.java#5 $
 **/
public interface AttributeMap {

    /**
     * Returns <code>true</code> if the attribute map contains an attribute
     * named <code>qName</code>.
     **/
    boolean contains(String qName);

    /**
     * Returns the value of the attribute named <code>qName</code>.
     **/
    String getValue(String qName);

    /**
     * Returns the number of attributes.
     **/
    int size();

    /**
     * Returns an iterator over the attribute names contained in this map.
     **/
     Iterator keys();

    /**
     * Returns an iterator over name-value {@link AttributeMap.Pair pairs}
     * contained in this map.
     **/
    Iterator pairs();

    /**
     * Represents a single attribute as a name-value pair. For example,
     * <code>&lt;p id="foo" class="rh"></code> has two pairs: ("id", "foo") and
     * ("class", "rh").
     **/
    public interface Pair {

        /**
         * Returns the attribute name.
         **/
        String getName();

        /**
         * Returns the attribute value.
         **/
        String getValue();
    }
}
