/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

/**
 * This interface is deprecated since it is Intermedia specific.
 * All code should now be using the generic search API found
 * in the com.arsdigita.search package.
 * @deprecated register a com.arsdigita.search.MetadataProvider instead
 **/
public interface Searchable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/Searchable.java#3 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Returns a short summary description of the object. This
     * information can then be displayed on a search results
     * page. Note that the summary is not automatically included in
     * the text that is indexed.
     **/
    public String getSearchSummary();

    /**
     * Returns a string to use as the text inside the link in the
     * search results
     **/
    public String getSearchLinkText();

    /**
     * Returns a url stub used to link to more information about this
     * object.
     **/
    public String getSearchUrlStub();

    /**
     * Returns an xml string of the text to index for this object. The
     * xml tags are used as section groups. If both
     * getSearchXMLContent and getSearchRawContent return empty
     * strings, the object will not be indexed.
     **/
    public String getSearchXMLContent();

    /**
     * Return the entire text body for indexing. If both
     * getSearchXMLContent and getSearchRawContent return empty
     * strings, the object will not be indexed.
     **/
    public byte[] getSearchRawContent();

    /**
     * Returns the language type of document.  According to the
     * example at: <a href="http://www.oradoc.com/ora817/inter.817/a77063/cdatai5.htm#43659">Oracle
     * interMedia text reference</a> the language code follows
     * <a href="http://www.loc.gov/standards/iso639-2/langhome.html">ISO 639-2</a>.
     * "eng" for English.
     **/
    public String getSearchLanguage();
}
