/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search.intermedia;

import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.SessionManager;
import org.apache.log4j.Logger;

/**
 * The ContentChangeTime class is used to store the time in which
 * content changes.
 *
 * @author Archit Shah
 **/
class ContentChangeTime {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/search/intermedia/ContentChangeTime.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Creates a s_logging category with name = to the full name of class
    private static final Logger s_log =
        Logger.getLogger(ContentChangeTime.class.getName());

    /**
     * no need to construct
     **/
    private ContentChangeTime() { }

    /**
     * getContentChangeTime - Uses the pdl retrieve code to retrieve the
     * earliest time in the content_change_time table.
     **/
    public static long getContentChangeTime() {
        DataQuery dq = SessionManager.getSession().retrieveQuery
            ("com.arsdigita.search.intermedia.getContentChangeTimes");

        Long result = null;
        if (dq.next()) {
            result = (Long) dq.get("timeLastChange");
        }
        dq.close();

        if (result == null) { return 0L; }
        return result.longValue();
    }

    /**
     * getEarliestTime - Returns the earliest time later than the
     * time indexing was started.
     **/
    public static long getEarliestTime(long timeIndexingStarted) {
        DataQuery query = SessionManager.getSession().retrieveQuery
            ("com.arsdigita.search.intermedia.getTimeEarliestNonSyncedChange");
        Filter f = query.addFilter("timeEarliestChange > :time");
        f.set("time", new Long(timeIndexingStarted));

        try {
            if (query.next()) {
                long earliestTime =
                    ((Long) query.get("timeEarliestChange")).longValue();
                return earliestTime;
            } else {
                String errMsg =
                    "ContentChangeTime.getEarliestTime did not return a row";
                s_log.warn( errMsg );
                return timeIndexingStarted + 1;
            }
        } finally {
            query.close();
        }
    }

    public static void flagChange() {
        DataOperation op = SessionManager.getSession().retrieveDataOperation
            ("com.arsdigita.search.intermedia.InsertContentChangeTime");
        Long now = new Long(System.currentTimeMillis());
        op.setParameter("timeLastChange", now);
        op.execute();
    }
}
