/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.util.Assert;


/**
 * A simple interface for caching sets
 * @see com.arsdigita.search.CachedResultSet
 */
public interface ResultCache {

    /**
     * Stores a result set in the cache
     * @param query the query to store results for
     * @param results the results to cache
     */
    void put(QuerySpecification query,
             ResultSet results);

    /**
     * Retrieves a result set from the cache
     * @param query the query to get results for
     * @return the cached result set, or null
     */
    ResultSet get(QuerySpecification query);

}
