/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.search;

import com.arsdigita.util.Assert;

/**
 * A filter type defines a condition on which a set 
 * of result documents can be restricted. An example
 * would be 'restrict by category'. 
 *
 * @see com.arsdigita.search.FilterSpecification
 */
public abstract class FilterType {

    private String m_key;
    private String m_description;
    
    /**
     * Creates a new filter type
     * @param key a unique key representing this filter type
     * @param description a human friendly description
     */
    protected FilterType(String key,
                         String description) {
        Assert.exists(key, String.class);
        Assert.exists(description, String.class);
        
        m_key = key;
        m_description = description;
    }
    
    /**
     * Gets the unique filter key
     * @return the filter key
     */
    public String getKey() {
        return m_key;
    }
    
    /** 
     * Gets the filter description
     * @return the filter description
     */
    public String getDescription() {
        return m_description;
    }
    
    /**
     * Two filter type objects compare
     * equal if they have the same filter
     * key
     */
    public boolean equals(Object o) {
        if (!(o instanceof FilterType)) {
            return false;
        }
        
        FilterType type = (FilterType)o;
        
        return m_key.equals(type.m_key);
    }

    /**
     * Returns a hashcode compatible with the
     * definition of the equals() method
     */
    public int hashCode() {
        return m_key.hashCode();
    }
    
}
