/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

/**
 * Subject to change.
 *
 * An error to indicate invalid configurations.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/runtime/ConfigError.java#4 $
 */
public class ConfigError extends Error {
    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/runtime/ConfigError.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (ConfigError.class);

    /**
     * Constructs a new configuration error with the content
     * <code>message</code>.
     *
     * @param message A <code>String</code> describing what's wrong;
     * it cannot be null
     */
    public ConfigError(final String message) {
        super(message);

        Assert.exists(message, String.class);
    }

    /**
     * Constructs a new configuration error with a default message.
     */
    public ConfigError() {
        super("Configuration is invalid");
    }
}
