/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.runtime;

import com.arsdigita.util.parameter.AbstractParameterContext;

/**
 * The AbstractScript class serves as a base class for scripts
 * intended to execute within the runtime environment provided by CCM.
 * A developer may write one of these scripts by extending
 * AbstractScript and providing a noargs constructor that registers
 * any {@link com.arsdigita.util.parameter parameters} required by the
 * script's run method.
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/

public abstract class AbstractScript extends AbstractParameterContext
    implements Script {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/runtime/AbstractScript.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Default constructor for derived classes.
     **/

    protected AbstractScript() {}

    /**
     * The run method is inoked to execute the script. Before calling
     * this method any required parameters registered by the noargs
     * constructer should be set.
     *
     * @param context the context in which to run the script
     **/

    public abstract void run(ScriptContext context);

}
