/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.portal;

import com.arsdigita.kernel.ACSObjectCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.util.Assert;

/**
 * 
 *
 * @see Portal
 * @author Justin Ross
 * @version $Id: //core-platform/dev/src/com/arsdigita/portal/PortalCollection.java#6 $
 */
public class PortalCollection extends ACSObjectCollection {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/portal/PortalCollection.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    protected PortalCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Get the current item as a Portal domain object.
     *
     * @return a Portal domain object.
     * @post return != null
     */
    public Portal getPortal() {
        DataObject dataObject = m_dataCollection.getDataObject();

        Portal portal = Portal.retrieve(dataObject);

        Assert.assertNotNull(portal, "portal");

        return portal;
    }
}
