/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.populate.apps;

import java.util.List;

import com.arsdigita.util.Assert;

/**
 * @author bche
 */
public class PopulateAppPair {
    private PopulateApp m_popApp;
    private List m_args;
    
    public PopulateAppPair(List popAppPair) {
        Assert.assertTrue(popAppPair.size() == 2);
        m_popApp = (PopulateApp)popAppPair.get(0);
        m_args = (List)popAppPair.get(1);
    }
    
    public PopulateAppPair(PopulateApp popApp, List args) {
        m_popApp = popApp;
        m_args = args;
    }
    
    public PopulateApp getPopulateApp() {
        return m_popApp;
    }
    
    public List getArgs() {
        return m_args;
    }
}
