/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterError;
import com.arsdigita.util.parameter.StringParameter;
import java.net.MalformedURLException;
import java.net.URL;


/**
 * A config class used by the ConfigRegistry itself. Contains the
 * waf.config.packages parameter and the waf.config.parents parameter.
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #5 $ $Date: 2004/04/07 $
 **/

public class RegistryConfig extends AbstractConfig {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/RegistryConfig.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static String[] array(String str) {
        if (str == null) {
            return null;
        } else {
            return StringUtils.split(str, ',');
        }
    }

    private Parameter m_packages = new StringParameter
        ("waf.config.packages", Parameter.OPTIONAL, new String[0]) {
        protected Object unmarshal(String value, ErrorList errs) {
            return array(value);
        }

        protected String marshal(Object obj) {
            return StringUtils.join((String[]) obj, ',');
        }
    };

    private Parameter m_parents = new StringParameter
        ("waf.config.parents", Parameter.OPTIONAL, new URL[0]) {
        protected Object unmarshal(String value, ErrorList errs) {
            String[] strs = array(value);
            URL[] result = new URL[strs.length];
            for (int i = 0; i < result.length; i++) {
                try {
                    result[i] = new URL(strs[i]);
                } catch (MalformedURLException e) {
                    errs.add(new ParameterError(this, e));
                }
            }
            if (!errs.isEmpty()) {
                return null;
            }
            return result;
        }

        protected String marshal(Object obj) {
            URL[] urls = (URL[]) obj;
            String[] strs = new String[urls.length];
            for (int i = 0; i < strs.length; i++) {
                strs[i] = urls[i].toExternalForm();
            }
            return StringUtils.join(strs, ',');
        }
    };

    /**
     * Constructs a new and empty config object.
     **/

    public RegistryConfig() {
        register(m_packages);
        register(m_parents);
    }

    /**
     * Returns the value of the waf.config.packages parameter.
     *
     * @return the value of the waf.config.packages parameter
     **/

    public String[] getPackages() {
        return (String[]) get(m_packages);
    }

    /**
     * Returns the value of the waf.config.parents parameter.
     *
     * @return the value of the waf.config.parents parameter
     **/

    public URL[] getParents() {
        return (URL[]) get(m_parents);
    }

}
