/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import java.io.*;

import org.apache.commons.cli.*;

/**
 * Command
 *
 * @author Rafael H. Schloming &lt;rhs@mit.edu&gt;
 * @version $Revision: #6 $ $Date: 2004/04/07 $
 **/

abstract class Command {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/packaging/Command.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private String m_name;
    private String m_summary;
    private boolean m_verbose;

    protected Command(String name, String summary) {
        m_name = name;
        m_summary = summary;
    }

    public String getName() {
        return m_name;
    }

    public String getSummary() {
        return m_summary;
    }

    void setVerbose(boolean value) {
        m_verbose = value;
    }

    public boolean isVerbose() {
        return m_verbose;
    }

    public abstract boolean run(String[] args);

    void usage(Options options, PrintStream out) {
        usage(options, out, "ccm " + getName());
    }

    void usage(Options options, PrintStream out, String args) {
        usage(options, out, "ccm " + getName(), args);
    }

    static void usage(Options options, PrintStream out, String command,
                      String args) {
        String str;
        if (args == null) {
            str = command;
        } else {
            str = command + " " + args;
        }

        HelpFormatter fmt = new HelpFormatter();
        PrintWriter w = new PrintWriter(out);
        fmt.printHelp(w, 80, str, "\nOptions:", options, 2, 4, null, true);
        w.flush();
    }

    static Options getOptions() {
        Options options = new Options();
        options.addOption
            (OptionBuilder
             .hasArg(false)
             .withLongOpt("usage")
             .withDescription("Print this message")
             .create());
        options.addOption
            (OptionBuilder
             .hasArg(false)
             .withLongOpt("help")
             .withDescription("Print this message")
             .create());
        return options;
    }

}
