/*
 * Copyright (C) 2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.packaging;

import com.arsdigita.util.parameter.*;
import com.arsdigita.util.*;

import java.io.*;
import java.util.*;

import org.apache.commons.cli.*;

/**
 * Clear
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/packaging/Clear.java#4 $
 */
class Clear extends Command {
    public final static String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/packaging/Clear.java#4 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Options s_options = getOptions();

    public Clear() {
        super("clear",
              "Clear one or more values in a CCM configuration database");
    }

    public boolean run(final String[] args) {
        final CommandLine line;

        try {
            line = new PosixParser().parse(s_options, args);
        } catch (ParseException e) {
            System.err.println(e.getMessage());
            return false;
        }

        if (args.length == 0) {
            usage(s_options, System.err, "PARAMETERS");
            return false;
        }

        if (line.hasOption("usage") || line.hasOption("help")) {
            usage(s_options, System.out, "PARAMETERS");
            return true;
        }

        final ConfigRegistry reg = new ConfigRegistry();
        final Config config = new Config(reg);
        config.load(System.err);

        final String[] keys = line.getArgs();
        final List errors = new ArrayList();
        final List params = new ArrayList();

        for (int i = 0; i < keys.length; i++) {
            final Parameter param = config.getParameter(keys[i]);

            if (param == null) {
                errors.add("no such parameter: " + keys[i]);
            } else {
                params.add(param);
            }
        }

        if (errors.isEmpty()) {
            final Iterator iter = params.iterator();

            while (iter.hasNext()) {
                config.set((Parameter) iter.next(), null);
            }

            if (config.validate(System.err)) {
                try {
                    config.save();
                } catch (IOException e) {
                    System.err.println(e.getMessage());
                    return false;
                }

                return true;
            } else {
                return false;
            }
        } else {
            final Iterator iter = errors.iterator();

            while (iter.hasNext()) {
                System.out.println((String) iter.next());
            }

            return false;
        }
    }
}
