/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.notification;

/**
 * Common constants used the various notification classes.
 *
 * @author Ron Henderson 
 * @version $Id: //core-platform/dev/src/com/arsdigita/notification/NotificationConstants.java#7 $
 */

interface NotificationConstants {

    // keys for persistent data

    public static final String DIGEST_ID      = "digestID";
    public static final String REQUEST_ID     = "requestID";
    public static final String MESSAGE_ID     = "messageID";
    public static final String PARTY_TO       = "partyTo";
    public static final String PARTY_TO_ADDR  = "partyToAddr";
    public static final String PARTY_FROM     = "partyFrom";
    public static final String RETRY_COUNT    = "retryCount";
    public static final String SUCCESS        = "success";
    public static final String EXPAND_GROUP   = "expandGroup";
    public static final String REQUEST_DATE   = "requestDate";
    public static final String FULFILL_DATE   = "fulfillDate";
    public static final String STATUS         = "status";
    public static final String MAX_RETRIES    = "maxRetries";
    public static final String EXPUNGE_P      = "expunge";
    public static final String EXPUNGE_MSG_P  = "expungeMessage";
    public static final String HEADER         = "header";
    public static final String SIGNATURE      = "signature";
    public static final String SUBJECT        = "subject";
    public static final String SEPARATOR      = "separator";
    public static final String FREQUENCY      = "frequency";
    public static final String NEXT_RUN       = "nextRun";

    // various states that a notification can be in

    public static final String PENDING        = "pending";
    public static final String QUEUED         = "queued";
    public static final String SENT           = "sent";
    public static final String FAILED         = "failed";
    public static final String FAILED_PARTIAL = "failed_partial";
    public static final String CANCELLED      = "cancelled";

    // special queries

    public static final String GET_SIMPLE_QUEUED_NOTIFICATIONS =
        "com.arsdigita.notification.GetSimpleQueuedNotifications";
    public static final String GET_DIGEST_QUEUED_NOTIFICATIONS =
        "com.arsdigita.notification.GetDigestQueuedNotifications";
}
