/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.mimetypes;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.UncheckedWrapperException;

import java.math.BigDecimal;

/**
 * Used to keep track of the status of the tables cms_mime_types and
 * mime_type_extensions.  Also keeps track of inso filter status.
 *
 * @author Jeff Teeters (teeters@arsdigita.com)
 *
 * @version $Revision: #5 $ $DateTime: 2004/04/07 16:07:11 $
 */
public class MimeTypeStatus extends DomainObject {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/mimetypes/MimeTypeStatus.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.cms.MimeTypeStatus";

    public static final String HASH_CODE = "hashCode";
    public static final String INSO_FILTER_WORKS = "insoFilterWorks";

    public MimeTypeStatus() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public MimeTypeStatus(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public MimeTypeStatus(DataObject obj) {
        super(obj);
    }

    protected MimeTypeStatus(String type) {
        super(type);
    }

    /**
     * Return the single MimeTypeStatus object.
     **/

    public static MimeTypeStatus getMimeTypeStatus () {
        BigDecimal id = new BigDecimal(1);
        MimeTypeStatus ms;
        try {
            ms = new MimeTypeStatus
                (new OID(MimeTypeStatus.BASE_DATA_OBJECT_TYPE, id));
            return ms;
        } catch (DataObjectNotFoundException e) {
            // need to log
            throw new UncheckedWrapperException("MimeTypeStatus.java:" +
                            "cms cms_mime_status table not initialized.", e);
        }
    }


    public BigDecimal getHashCode() {
        return (BigDecimal) get(HASH_CODE);
    }

    public void setHashCode(BigDecimal value) {
        set(HASH_CODE, value);
    }

    public BigDecimal getInsoFilterWorks() {
        return (BigDecimal) get(INSO_FILTER_WORKS);
    }

    public void setInsoFilterWorks(BigDecimal value) {
        set(INSO_FILTER_WORKS, value);
    }
}
