/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.ui;

import java.math.BigDecimal;
import com.arsdigita.bebop.tree.TreeNode;
import java.util.HashMap;

/**
 * 
 *  A simple tree node database backed trees.
 *
 *
 * @author Daniel Berrange 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/kernel/ui/DataQueryTreeNode.java#9 $
 */


public class DataQueryTreeNode implements TreeNode  {
    private BigDecimal m_id;
    private String m_name;
    private boolean m_hasChild;
    private HashMap m_values;

    public DataQueryTreeNode(BigDecimal id,
                             String name,
                             boolean hasChild) {
        m_id = id;
        m_name = name;
        m_hasChild = hasChild;
        m_values = null;
    }

    public Object getKey() {
        return m_id.toString();
    }

    public Object getElement() {
        return m_name;
    }

    public BigDecimal getID() {
        return m_id;
    }

    public boolean hasChildren() {
        return m_hasChild;
    }

    public void setValue(String key, Object value) {
        if (m_values == null) {
            m_values = new HashMap();
        }
        m_values.put(key, value);
    }

    public Object getValue(String key) {
        if (m_values != null) {
            return m_values.get(key);
        } else {
            return null;
        }
    }
}
