/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel.security;

import javax.servlet.http.HttpServletRequest;

/**
 *  Provides methods for
 * determining security properties for a request.
 *
 * @author Sameer Ajmani
 **/
public interface SecurityHelper {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/security/SecurityHelper.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    /**
     * Determines whether the given request is secure.  Implementation may
     * simply return <code>req.isSecure()</code>, but certain deployments
     * may use other information (such as the requested port number)
     * instead.
     *
     * @param req the request to check
     *
     * @return <code>true</code> if the given request uses a secure
     * protocol, <code>false</code> otherwise.
     **/
    public boolean isSecure(HttpServletRequest req);

    /**
     * Determines whether the given request requires the user to be logged
     * in.  If this method returns <code>true</code>, the system will call
     * <code>getLoginURL</code> to determine where to redirect the client to
     * log in.
     *
     * @param req the request to check
     *
     * @return <code>true</code> if the given request requires the user to
     * be logged in, <code>false</code> otherwise.
     **/
    public boolean requiresLogin(HttpServletRequest req);

    /**
     * Determines where to redirect the client to log in.  The system calls
     * this method if the user fails to log in and
     * <code>requiresLogin(req)</code> is true.
     *
     * @return the URL to which the client should be redirected to log in,
     * never null.
     **/
    public String getLoginURL(HttpServletRequest req);
}
