/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

/**
 * <p>A collection of ResourceTypes.  This class includes methods
 * to filter and order the results of retrieving resource
 * types.</p>
 *
 * @see com.arsdigita.kernel.ResourceType
 * @see com.arsdigita.kernel.ResourceCollection
 * @author Jim Parsons
 */
public class ResourceTypeCollection extends DomainCollection {

    private static final Logger s_log = Logger.getLogger
        (ResourceTypeCollection.class);

    public ResourceTypeCollection(DataCollection dataCollection) {
        super(dataCollection);
    }


    public void orderByTitle() {
        m_dataCollection.addOrder("title");
    }

    public DomainObject getDomainObject() {
        return getResourceType();
    }


    public ResourceType getResourceType() {
        DataObject dataObject = m_dataCollection.getDataObject();

        Assert.assertNotNull(dataObject, "dataObject");

        ResourceType resourceType =
            ResourceType.retrieveResourceType(dataObject);

        return resourceType;
    }

    public String getResourceObjectType() {
        return (String) m_dataCollection.get("objectType");
    }

    public String getTitle() {
        return (String) m_dataCollection.get("title");
    }

    public BigDecimal getID() {
        return (BigDecimal)m_dataCollection.get("id");
    }

}
