/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

/**
 * <p>A collection of Resources.  This class includes methods to
 * filter and order the results of retrieving resources.</p>
 *
 * @see com.arsdigita.kernel.Resource
 * @see com.arsdigita.kernel.ResourceType
 * @see com.arsdigita.kernel.ResourceTypeCollection
 * @author Jim Parsons &lt;<a href="mailto:jparsons@redhat.com">jparsons@redhat.com</a>&gt;
 */
public class ResourceCollection extends ACSObjectCollection {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/kernel/ResourceCollection.java#5 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (ResourceCollection.class);

    public ResourceCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    public void filterToResourceType(String type) {
        m_dataCollection.addEqualsFilter(ACSObject.OBJECT_TYPE, type);
    }


    /**
     * Orders by the title of the application type.
     **/
    public void orderByTypeTitle() {
        m_dataCollection.addOrder("resourceType.title");
    }

    public void orderByTitle() {
        m_dataCollection.addOrder("title");
    }

    public void orderByParentTitle() {
        m_dataCollection.addOrder("parentResource.title");
    }

    /**
     * Get the current item as an Resource domain object.
     *
     * @return a Resource domain object.
     * @post return != null
     */
    public Resource getResource() {
        DataObject dataObject = m_dataCollection.getDataObject();

        Resource resource =
            Resource.retrieveResource(dataObject);

        Assert.assertNotNull(resource, "resource");

        return resource;
    }

    /**
     * Get the title for the resource for the current row.
     *
     * @return the title of this resource.
     * @post return != null
     */
    public String getTitle() {
        String title = (String)m_dataCollection.get("title");

        Assert.assertNotNull(title, "title");

        return title;
    }

    /**
     * Returns the title of the parent resource.
     *
     * @return The title of the parent resource.
     **/
    public String getParentTitle() {
        return (String) m_dataCollection.get("parentResource.title");
    }

    public String getDescription() {
        return (String) m_dataCollection.get("description");
    }

}
