/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.kernel;

import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.Filter;

/**
 * Represents a collection of parties.
 *
 * @author Phong Nguyen 
 * @version 1.0
 **/
public class PartyCollection extends ACSObjectCollection {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/kernel/PartyCollection.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Constructor.
     *
     * @see ACSObjectCollection#ACSObjectCollection(DataCollection)
     **/
    public PartyCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Returns the URI for this party.
     *
     * @return the URI for this party.
     **/
    public String getURI() {
        return (String) m_dataCollection.get("uri");
    }

    /**
     * Wrapper to <code>getDomainObject()</code> that casts the returned
     * <code>DomainObject</code> as a <code>Party</code>.
     *
     * @return a <code>Party</code> for the current position in the
     * collection.
     *
     * @see ACSObjectCollection#getDomainObject()
     * @see Party
     * @see com.arsdigita.domain.DomainObject
     **/
    public Party getParty() {
        return (Party) getDomainObject();
    }

    /**
     *
     * Filter this party collection to parties whose name or email
     * contain the given search string.
     **/
    public void filter(String searchString) {
        Filter f = m_dataCollection.getFilterFactory()
            .or()
            .addFilter("lower(displayName) like '%' || :s || '%'")
            .addFilter("lower(primaryEmail) like '%' || :s || '%'");
        f.set("s", searchString.toLowerCase());
        m_dataCollection.addFilter(f);
    }

    /**
     *
     * Get the primary email address of this party.
     **/
    public EmailAddress getPrimaryEmail() {
        String email = (String) m_dataCollection.get("primaryEmail");
        if (email==null) {
            return null;
        }
        return new EmailAddress((String) m_dataCollection.get("primaryEmail"));
    }
}
