/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.globalization;

/**
 * <p>
 * Manages Accept-Language HTTP header as defined in RFC 2616.
 * </p>
 *
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 */
public class AcceptLanguageHeader extends AcceptHeader {
    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/globalization/AcceptLanguageHeader.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * <p>
     * Constructor.
     * </p>
     *
     * @param acceptLanguage String passed in from the browser representing
     *        the Accept-Language HTTP header.
     */
    public AcceptLanguageHeader(String acceptLanguage) {
        m_acceptHeader = acceptLanguage;
        setAcceptFields();
    }

    protected AcceptField createAcceptField(String acceptField) {
        return new AcceptLanguage(acceptField);
    }
}
