/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.jsp;

import com.arsdigita.bebop.Component;
import javax.servlet.jsp.JspException;
import com.arsdigita.bebop.jsp.DefineComponent;


public abstract class DefineForm extends DefineComponent {
    private JspForm m_form;

    public int doStartTag() throws JspException {
        m_form = getJspForm(getName());

        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        return super.doEndTag();
    }

    public void setVariable(String name,
                            String value) {
        m_form.setVariable(name, value);
    }

    public Component getComponent() {
        return m_form;
    }

    /**
     * This method should return a suitable
     * subclass of JspForm
     */
    protected abstract JspForm getJspForm(String name);
}
