/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui.editors;


import com.arsdigita.formbuilder.util.GlobalizationUtil ; 

import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import java.util.TooManyListenersException;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.formbuilder.PersistentWidget;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.formbuilder.PersistentOptionGroup;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.formbuilder.PersistentOption;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.FormProcessException;
import java.util.Iterator;
import com.arsdigita.bebop.PageState;
import java.math.BigDecimal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.xml.Element;
import com.arsdigita.bebop.ColumnPanel;



public abstract class OptionGroupForm extends WidgetLabelForm {
    private OptionGroup m_value;
    private Label m_value_label;
    private Iterator m_opts;

    SingleSelectionModel m_control;

    public OptionGroupForm(String name,
                           SingleSelectionModel form,
                           SingleSelectionModel control) {
        super(name, form, control);

        m_control = control;
    }

    protected void addWidgets(FormSection section) {
        super.addWidgets(section);

        m_value = getOptionGroup("value");
        m_value_label = new Label(GlobalizationUtil.globalize("formbuilder.ui.editors.value"));

        section.add(m_value_label, ColumnPanel.RIGHT);
        section.add(m_value);
        try {
            m_value.addPrintListener(new ControlFormPrintListener());
        } catch (TooManyListenersException ex) {
            throw new UncheckedWrapperException("This will never happen", ex);
        }
    }

    protected abstract OptionGroup getOptionGroup(String name);

    public void generateXML(PageState state,
                            Element parent) {
        BigDecimal control = (BigDecimal)m_control.getSelectedKey(state);
        PersistentOptionGroup group = null;
        if (control != null) {
            try {
                group = (PersistentOptionGroup)getWidget(control);
            } catch (DataObjectNotFoundException ex) {
                throw new UncheckedWrapperException("cannot find persistent option group", ex);
            }
        }

        if (group != null) {
            m_opts = group.getOptions().iterator();
            m_value.setVisible(state, m_opts.hasNext());
            m_value_label.setVisible(state, m_opts.hasNext());
        } else {
            m_opts = null;
            m_value.setVisible(state, false);
            m_value_label.setVisible(state, false);
        }

        super.generateXML(state, parent);
    }

    protected void initWidgets(FormSectionEvent e,
                               PersistentWidget w)
        throws FormProcessException {
        super.initWidgets(e, w);

        PageState state = e.getPageState();
    }

    protected void processWidgets(FormSectionEvent e,
                                  PersistentWidget w)
        throws FormProcessException {
        super.processWidgets(e, w);
    }

    private class ControlFormPrintListener implements PrintListener {
        public void prepare(PrintEvent e) {
            if (m_opts == null)
                return;

            OptionGroup grp = (OptionGroup)e.getTarget();

            while (m_opts.hasNext()) {
                PersistentOption o = (PersistentOption)m_opts.next();

                grp.addOption(new Option(o.getParameterValue(), o.getLabel()));
            }
        }
    }
}
