/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


import com.arsdigita.bebop.PageState;

import com.arsdigita.formbuilder.AttributeMetaDataProvider;


/**
 * The PropertiesMetaForm uses this interface to draw information
 * from its containing page. By using this interface we keep the
 * form decoupled from its page so that it can be embedded in
 * different pages.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/PropertiesMetaFormConnector.java#7 $
 */
public interface PropertiesMetaFormConnector {

    /**
     * The FormPropertiesForm will be in either add or edit mode.
     * If this method returns true edit mode will be used
     */
    public boolean isInEditMode(PageState pageState);

    /**
     * The purpose of the FormPropertiesForm is to edit properties of a SimpleQuestionnaire.
     * The form will access this SimpleQuestionnaire through this method
     */
    public AttributeMetaDataProvider getAttributeMetaDataProvider(PageState pageState);
}
