/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder.ui;


import com.arsdigita.formbuilder.FormSectionGenerator;
import com.arsdigita.formbuilder.AttributeMetaDataProvider;

import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.BlockStylable;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.MetaForm;
import com.arsdigita.bebop.form.Submit;

import com.arsdigita.bebop.PageState;

// logging
import org.apache.log4j.Logger;

/**
 * A form for adding or editing a DomainObject that implements the
 * AttributeMetaDataProvider interface. The form will be generated on the
 * fly when the page is requested.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/PropertiesMetaForm.java#8 $
 *
 */
public class PropertiesMetaForm extends MetaForm {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/ui/PropertiesMetaForm.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Logging
    private static final Logger s_log =
        Logger.getLogger(PropertiesMetaForm.class);

    private PropertiesMetaFormConnector m_pageConnector;

    public PropertiesMetaForm(PropertiesMetaFormConnector pageConnector) {
        super("PropertiesMetaForm");

        m_pageConnector = pageConnector;
    }

    public Form buildForm(PageState pageState) {

        Form form = new Form("form_properties");

        form.add(generateFormSection(pageState));

        form.add(new Submit(getSubmitLabel(pageState)),
                 BlockStylable.FULL_WIDTH | BlockStylable.CENTER);

        return form;
    }

    private FormSection generateFormSection(PageState pageState) {

        AttributeMetaDataProvider attributeProvider =
            m_pageConnector.getAttributeMetaDataProvider(pageState);

        FormSectionGenerator formGenerator =
            new FormSectionGenerator(attributeProvider);

        boolean isAdd = !m_pageConnector.isInEditMode(pageState);

        return formGenerator.generateFormSection(true,
                                                 isAdd);
    }

    private String getSubmitLabel(PageState pageState) {

        if (m_pageConnector.isInEditMode(pageState)) {
            return "edit";
        } else {
            return "add";
        }
    }
}
